-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
dofile( "scripts/tittle_style.lua" );

kTitleY			= 50;
kButtonSpacing	= 75;	-- Put our buttons 60 pixels apart
kButtonY		= kCenter;	-- Three buttons means center 60 pixels above the center
kButtonCollumn	= 70;	-- There is two collumns and there is correction from kCenter
kTextButton		= 30;
MakeDialog
{
	w=800,
	h=600,
	
	-- Name the modal dialog
	name="pausemenu",
	Bitmap
	{

		image="images/ui/common/popup06",
		x=kCenter,
		y=kCenter,
		alpha = true,

		Text
		{
			font	= PopupFont,
			x		= kCenter,
			y		=kTitleY+140,
			w=kMax,h=30,
			flags = kHAlignCenter + kVAlignTop,
			label = "ui.dialog.pause.title"
		};
		SetStyle(FitnessButtonStyleTittleSmallBlue),
	
	--//Resume
		SBButton
		{
			x=kCenter - kButtonCollumn,
			y=kButtonY,
			
			icon="assets/images/ui/buttons/icon/iconresume",
			command=
				function()
					PopModal("pausemenu");
					SendGameMessage( "ui.game.unpause" );
				end
		},
		Text
		{
			font = SmallFont,
			x=kCenter - kButtonCollumn,
			y=kButtonY+kTextButton,
			flags = kHAlignCenter + kVAlignCenter,
			label="ui.dialog.pause.resume.label",
		};
	--//Restart	
		SBButton
		{
			x=kCenter,
			y=kButtonY,
			
			icon="assets/images/ui/buttons/icon/iconrestart",
			command=
				function()
					PopModal("pausemenu");
					DoModal("scripts/restart_level.lua");
				end
		},
		Text
		{
			font = SmallFont,
			x=kCenter,
			y=kButtonY+kTextButton,
			flags = kHAlignCenter + kVAlignCenter,
			label="pause.restart",
		};
	--//Options
		SBButton
		{
			x=kCenter + kButtonCollumn,
			y=kButtonY,
			
			icon="assets/images/ui/buttons/icon/iconoption",
			command=
				function()
					-- Pop up an options screen
					DoModal("scripts/options.lua");
				end
		},
		Text
		{
			font = SmallFont,
			x=kCenter + kButtonCollumn,
			y=kButtonY + kTextButton,
			flags = kHAlignCenter + kVAlignCenter,
			label="options",
		};
	--//Help
		SBButton
		{
			x = kCenter - kButtonCollumn,
			y = kButtonY + kButtonSpacing,
			
			icon="assets/images/ui/buttons/icon/iconhelp",
			command=
				function()
					--PopModal("pausemenu");
					DoModal("scripts/help1.lua");
				end
		},
		Text
		{
			font = SmallFont,
			x=kCenter - kButtonCollumn,
			y=kButtonY + kButtonSpacing + kTextButton,
			flags = kHAlignCenter + kVAlignCenter,
			label="help",
		};
	--//Trophies
		SBButton
		{
			x=kCenter,
			y=kButtonY + kButtonSpacing,
			
			icon="assets/images/ui/buttons/icon/icontrophy",
			command=
				function()
                  DoModal("scripts/medals.lua");
			end
		},
		Text
		{
			font = SmallFont,
			x=kCenter,
			y=kButtonY + kButtonSpacing + kTextButton,
			flags = kHAlignCenter + kVAlignCenter,
			label="trophies",
		};
	
	--//Quit	
		SBButton
		{
			x=kCenter + kButtonCollumn,
			y=kButtonY + kButtonSpacing,
			
			icon="assets/images/ui/buttons/icon/iconquit",
			command=
				function()
					-- Our game provides this call--it's not a Playground
					-- call.
					
					result = DisplayDialog {
						"scripts/yesno.lua",
						body ="ui.dialog.mainmenu.confirm",
						title = "ui.dialog.mainmenu.title",
					};
					if (result=='yes') then
						if(GetCurrentGameMode() == eStoryMode)then			--Fitness Mode
							PopModal("pausemenu");
							SendGameMessage("ui.pause.quit");
							DoModal("scripts/mainmenu.lua");
						
						elseif(GetCurrentGameMode() >= eFitnessEasy and GetCurrentGameMode() <= eFitnessHard ) then			
							PopModal("LevelDialogGenerator" );
							DoModal("scripts/mainmenu.lua");
						else
							PopModal("tugofwar");
							DoModal("scripts/mainmenu.lua");
						end	
					end
				end
		},
		Text
		{
			font = SmallFont,
			x=kCenter + kButtonCollumn,
			y=kButtonY + kButtonSpacing + kTextButton,
			flags = kHAlignCenter + kVAlignCenter,
			label="quit",
		};
	},
}